//
//  SPLinearGradient.m
//  SamplePlugIn
//
//  Created by Kai on 27.1.08.
//  Copyright 2008 __MyCompanyName__. All rights reserved.
//

#import "SPLinearGradient.h"


//-------------------------------------------------------------------------------------------
@implementation SPLinearGradient
//-------------------------------------------------------------------------------------------

//-------------------------------------------------------------------------------------------
- (id) initWithStartingColor:(NSColor*)startingColor
					  endingColor:(NSColor*)endingColor
							  angle:(float)angle {
	self = [super init];
	if (self) {
		_startingColor = [startingColor copy];
		_endingColor = [endingColor copy];
		_angle = angle;
	}
	return self;
}

//-------------------------------------------------------------------------------------------
- (id) init {
	return [self initWithStartingColor:nil endingColor:nil angle:270];
}

//-------------------------------------------------------------------------------------------
- (void) dealloc {
	[_startingColor release];
	[_endingColor release];
	[_gradient release];
	
	[super dealloc];
}

//-------------------------------------------------------------------------------------------
- (NSColor*) startingColor { return [[_startingColor retain] autorelease]; }

//-------------------------------------------------------------------------------------------
- (void) setStartingColor:(NSColor*)value {
	if (value != _startingColor) {
		[_startingColor release];
		_startingColor = [value copy];	// TODO: validate that copy just retains due to immutability
		
		// Gradient must be recreated.
		[_gradient release], _gradient = nil;
	}
}

//-------------------------------------------------------------------------------------------
- (NSColor*) endingColor { return [[_endingColor retain] autorelease]; }

//-------------------------------------------------------------------------------------------
- (void) setEndingColor:(NSColor*)value {
	if (value != _endingColor) {
		[_endingColor release];
		_endingColor = [value copy];	// TODO: validate that copy just retains due to immutability
		
		// Gradient must be recreated.
		[_gradient release], _gradient = nil;
	}
}

//-------------------------------------------------------------------------------------------
- (float) angle { return _angle; }

//-------------------------------------------------------------------------------------------
- (void) setAngle:(float)value {
	_angle = value;
}

//-------------------------------------------------------------------------------------------
- (NSGradient*) gradient {
	// Create the gradient object lazzily.
	if (_gradient == nil) {
		_gradient  = [[NSGradient alloc] initWithStartingColor:_startingColor
																 endingColor:_endingColor];
	}
	return _gradient;
}


//-------------------------------------------------------------------------------------------
- (void) drawInRect:(NSRect)rect {
	[[self gradient] drawInRect:rect angle:_angle];
}


//-------------------------------------------------------------------------------------------
- (void) drawInBezierPath:(NSBezierPath*)path {
	[[self gradient] drawInBezierPath:path angle:_angle];
}

#pragma mark NSCopying Protocol -------------------------------------------------------------
//-------------------------------------------------------------------------------------------
- (id) copyWithZone:(NSZone*)zone {
	// NSCopying protocol.
	return [[SPLinearGradient allocWithZone:zone]
			  initWithStartingColor:_startingColor endingColor:_endingColor angle:_angle];
}

#pragma mark NSCoding Protocol --------------------------------------------------------------
//-------------------------------------------------------------------------------------------
- (id) initWithCoder:(NSCoder*)decoder {
	NSAssert ([decoder allowsKeyedCoding], @"oops, got a sequential archive");
	
	self = [super init];
	if (self) {
		// Note: can decode keys in any order
		_startingColor	= [[decoder decodeObjectForKey:@"SP_startingColor"] retain];
		_endingColor	= [[decoder decodeObjectForKey:@"SP_endingColor"] retain];
		_angle			= [decoder decodeFloatForKey:@"SP_angle"];
	}
	
	return self;
}

//-------------------------------------------------------------------------------------------
- (void) encodeWithCoder:(NSCoder*)encoder {
	NSAssert ([encoder allowsKeyedCoding], @"oops, got a sequential archive");
	
	[encoder encodeObject:_startingColor forKey:@"SP_startingColor"];
	[encoder encodeObject:_endingColor forKey:@"SP_endingColor"];
	[encoder encodeFloat:_angle forKey:@"SP_angle"];
}


@end
